;*******************************************************************************************************
;
; Author	: 	 
;
; File	:	 app1.asm
;
; Hardware      : 	ADuC812BS
;
; Description   :	        RS232,
;		 ADC0 -  
;		 DAC0    
;		 DAC1     
;		TIMER0     
;		P2.0 - P2.3 -  
;		P2.4 - P2.7 -    
;		P0.5 - P0.7 -   (" ", " ", " ." )
;		P0.0       
;		P0.4       
;********************************************************************************************************

$MOD812                         ; Use 8052&ADuC812 predefined symbols

;   RS232    ,  
;  BUFRXD ( 18h ) 
;  :
;<$><2  -  ><1 - 4  - >< 0Dh - >
;     ,   BUFTRD ( 10h )
;  : <!><2  -  ><1 - 4  - >< 0Dh - >
	TIMESTEP			DATA	28h	;  - ms    
	NCNVRT			DATA	27h	;-  ( >=16 )
	SIGHI			DATA	26h	;.   
	SIGLO			DATA	25h	;.   
	SRSST			DATA	24h	;    
	STEPHI			DATA	23h	;  - ,  
						; 
	STEPLO			DATA	22h	;  - ,  
						;
	PHASESM		DATA	21h	;    
	BYTESR			DATA	20h	;   
	ARBEG			DATA	08h	;   ,  
						;   ASII   
						;  
	ARNUM			DATA	09h	;   -    ASII
						;,     
						;
	ARLO			DATA	0Ah	;.      ASII  BIN
	ARHI			DATA	0Bh	;.      ASII  BIN
	FLAGPRC		BIT	78h	;    
	DIRECTION		BIT	79h	; ,    ..
	BUFRXD			EQU	18h	;    
	BUFTRD			EQU	10h	;     
	PULSE			EQU	P0.0	;  
	ONHV			EQU	P0.4	;  .   
	LDTRD			EQU	P0.5	;  
	LDRXD			EQU	P0.6	; Ȩ 
	LDUHV			EQU	P0.7	; 
	END1			EQU	P3.2	; 1
	END2			EQU	P3.3	; 2

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                                                  ; BEGINNING OF CODE
CSEG

ORG 0000h

	JMP     MAIN            ; jump to main program

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
ORG 000Bh			;TIMER0 Interrupt vector
	CPL	PULSE		; ,   
	RETI

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
ORG 0023h			;serial port Interrupt vector
	JMP	SERREC		;       

;====================================================================
			;  
ORG 0100h

MAIN:

;____________________________________________________________________________
;		   -     

	;----------------------------------------- -----------------------------------------

	MOV	SP,#030h	;  
	MOV	PHASESM,#00000011b	;  
	MOV	P2,#00000011b	;    
	MOV	P0,#00000000b	;  ,  PULSE  ON/OFF UHV
	MOV	BYTESR,#00h	;   

	MOV	SCON,#050h	;- SERIAL PORT   8-bit UART
	MOV	TMOD,#022h	;  1  0
	MOV	TH1,#0FDh	;   9600
	SETB	EA		;  
	SETB	ES		;   SERIAL PORT
	MOV	IP,#02h		; .TIMER 0
	SETB	REN		; 
	SETB	TR1		; TIMER1
		
	MOV	DACCON	,#00000111b	; 	
					; 	
	MOV	ADCCON1,#01100000b	;	
	MOV	ADCCON2,#00000000b	;
	;----------------------------------------- -----------------------------------------

MLOOP:	JNB	FLAGPRC,MLOOP
	ACALL	PRCCMD		;    
	SJMP	MLOOP		;	

;===================================================================

			;
;____________________________________________________________________________
;    SERIAL PORT
SERREC:
	JNB	RI,$		;  
	CLR	RI		;  
	CPL	LDRXD		;  
	MOV 	A,SBUF		;  
	CJNE	A,#'$',SR1	;,    
	MOV	BYTESR,#00h	;   
	RETI			;    
SR1:	CJNE	A,#0Dh,SR2	;,    
	SETB	FLAGPRC	;   
	RETI			;    
SR2:	
	CLR	RS0		;..
	CLR	RS1		;..  
	MOV	A,#BUFRXD	; ..
	ADD	A,BYTESR	;.. ..
	MOV	R0,A		;..  ..
	MOV	@R0,SBUF	;..      
	INC	BYTESR		;   
	RETI			;    

;____________________________________________________________________________
;   
PRCCMD:
	;--------     ---------
	MOV	ARNUM,#02h	;-    
	MOV	ARBEG,#BUFRXD	;   .. 
	INC	ARBEG		;..  ASII 
	CALL	ASIITOB		;   ASII  ..
				;..  
				;..   
	CLR	FLAGPRC
	;        
	MOV	B,ARLO
	MOV	A,#14
	CLR	C
	SUBB	A,B
	JNC	PC1
	MOV	ARLO,#15
PC1:	MOV	A,ARLO
	MOV	B,#08h
	MUL	AB
	XCH	A,B
	MOV	DPTR,#0200h
	ADD	A,DPH
	XCH	A,DPH
	MOV	A,B
	JMP	@A+DPTR

ORG 0200h
	LCALL	CMD00
	RET
ORG 0208h
	LCALL	CMD01
	RET
ORG 0210h
	LCALL	CMD02
	RET
ORG 0218h
	LCALL	CMD03
	RET
ORG 0220h
	LCALL	CMD04
	RET
ORG 0228h
	LCALL	CMD05
	RET
ORG 0230h
	LCALL	CMD06
	RET
ORG 0238h
	LCALL	CMD07
	RET
ORG 0240h
	LCALL	CMD08
	RET
ORG 0248h
	LCALL	CMD09
	RET
ORG 0250h
	LCALL	CMD10
	RET
ORG 0258h
	LCALL	CMD11
	RET
ORG 0260h
	LCALL	CMD12
	RET
ORG 0268h
	LCALL	CMD13
	RET
ORG 0270h
	LCALL	CMD14
	RET
ORG 0278h
	LCALL	CMD15
	RET
;____________________________________________________________________________
;  00 ""
CMD00:			

				;  
	MOV	02h,#'5'		;
	MOV	03h,#'0'		;
	LCALL	PREPCMD	;
		;     
		;    
	MOV	B,#06h
	MOV	DPTR,#IDENTIF
C001:	MOV	A,R0
	MOVC	A,@A+DPTR
	MOV	@R1,A
	INC	R1
	INC	R0
	DJNZ	B,C001

	MOV	A,#08h
	LCALL TRANSM

	RET

;____________________________________________________________________________
;  01 " "
CMD01:			
				;  
	MOV	02h,#'5'		;
	MOV	03h,#'1'		;
	LCALL	PREPCMD	;
		;     
	MOV	B,BYTESR
	MOV	R0,#BUFRXD
	INC	R0
	INC	R0
C011:	MOV	A,@R0
	MOV	@R1,A
	INC	R0
	INC	R1
	DJNZ	B,C011
			; 
	MOV	A,BYTESR
	LCALL TRANSM

	RET
;____________________________________________________________________________
;  02 "/  "
CMD02:	
	CLR	RS0
	CLR	RS1
	MOV	R0,#BUFRXD
	INC	R0
	INC	R0
	MOV	A,@R0	
	CJNE	A,#'Y',C021
	SETB	ET0		;   TIMER 0 
	SETB	TR0		; TIMER 0 
	ORL	DACCON,#00010000b	;. DAC1
	SJMP	C022

C021:	CLR	ET0		;   TIMER 0 
	CLR	TR0		; TIMER 0 
	ANL	DACCON,#11101111b	;. DAC1	
	CLR	PULSE		; 
	MOV	SRSST,#00h	; ..
	MOV	P2,PHASESM	;..  
	

C022:				;     
	MOV	02h,#'5'		;
	MOV	03h,#'2'		;
	LCALL	PREPCMD	;
	LCALL	PREPMES1	;
	MOV	A,#04h
	LCALL TRANSM

	RET
;____________________________________________________________________________
;  03 "  "
CMD03:			
	CLR	RS0
	CLR	RS1
	MOV	R0,#BUFRXD
	INC	R0
	INC	R0
	MOV	A,@R0		;      ASII 
	CLR	C		;
	SUBB	A,#30h		;  -   	
	ADD	A,#03h		; -    
				; 
	MOV	B,A		;   
				;    
	MOV	A,#01h		;
C031:	RL	A		;
	DJNZ	B,C031		;
	MOV	SRSST,A	;
	ORL	A,PHASESM	;
	MOV	P2,A		;
				;     
	MOV	02h,#'5'		;
	MOV	03h,#'3'		;
	LCALL	PREPCMD	;
	LCALL	PREPMES1	;
	MOV	A,#04h
	LCALL TRANSM

	RET
;____________________________________________________________________________
;  04 "  "
CMD04:			
	LCALL	VALINI
	LCALL	ASIITOB
	MOV	DAC1H,ARHI
	MOV	DAC1L,ARLO
	
				;     
	MOV	02h,#'5'		;
	MOV	03h,#'4'		;
	LCALL	PREPCMD	;
	LCALL	PREPMES1	;
	MOV	A,#04h
	LCALL TRANSM
	
	RET
;____________________________________________________________________________
;  05 "/   "
CMD05:			
	CLR	RS0
	CLR	RS1
	MOV	R0,#BUFRXD
	INC	R0
	INC	R0
	MOV	A,@R0	
	CJNE	A,#'Y',C051
	SETB	ONHV		;.   
	SETB	LDUHV		;.  
	ORL	DACCON,#00001000b	;. DAC0
	SJMP	C052
C051:	CLR	ONHV		;.   
	CLR	LDUHV		;.  
	ANL	DACCON,#111101111b	;. DAC1	
C052:				;     
	MOV	02h,#'5'		;
	MOV	03h,#'5'		;
	LCALL	PREPCMD	;
	LCALL	PREPMES1	;
	MOV	A,#04h
	LCALL TRANSM

	RET
;____________________________________________________________________________
;  06 " "
CMD06:			
	LCALL	VALINI
	LCALL	ASIITOB
	MOV	DAC0H,ARHI
	MOV	DAC0L,ARLO
	
				;     
	MOV	02h,#'5'		;
	MOV	03h,#'6'		;
	LCALL	PREPCMD	;
	LCALL	PREPMES1	;
	MOV	A,#04h
	LCALL TRANSM
		
	RET
;____________________________________________________________________________
;  07 "    "
CMD07:		
	SETB	DIRECTION	; 
	LCALL	VALINI		;
	LCALL	ASIITOB		;   BIN 
	MOV	STEPLO,ARLO	;
	MOV	STEPHI,ARHI	;
	ACALL	STEPING	;  
				;     
	MOV	02h,#'5'		;
	MOV	03h,#'7'		;
	LCALL	PREPCMD	;
	LCALL	PREPMES1	;
	MOV	A,#04h
	LCALL TRANSM

	RET
;____________________________________________________________________________
;  08 "    "
CMD08:			
	CLR	DIRECTION	; 	
	LCALL	VALINI		;
	LCALL	ASIITOB		;   BIN 
	MOV	STEPLO,ARLO	;
	MOV	STEPHI,ARHI	;
	ACALL	STEPING	;  

				;     
	MOV	02h,#'5'		;
	MOV	03h,#'8'		;
	LCALL	PREPCMD	;
	LCALL	PREPMES1	;
	MOV	A,#04h		;
	LCALL TRANSM		;

	RET
;____________________________________________________________________________
;     ,   
STEPING:
	MOV	A,TIMESTEP	;  - - 
SG1:	LCALL	ONEMS		;   1 
	DJNZ	ACC,SG1	
	CALL	ONESTEP	; 		
				;    1
	CLR	C
	MOV	A,STEPLO	;
	SUBB	A,#01h;		;
	MOV	STEPLO,A	;
	MOV	A,STEPHI	;
	SUBB	A,#00h		;
	MOV	STEPHI,A	;
				;     ?
	JNZ	STEPING	;
	MOV	A,STEPLO	;
	JNZ	STEPING	;

	RET
;____________________________________________________________________________
;  09 "   END1"
CMD09:	
	SETB	DIRECTION
C092:
	MOV	A,TIMESTEP	;  - - 
C091:	LCALL	ONEMS		;   1 
	DJNZ	ACC,C091		;
	LCALL	ONESTEP	
	MOV	C,END1	
	JC	C092	
				;     
	MOV	02h,#'5'		;
	MOV	03h,#'9'		;
	LCALL	PREPCMD	;
	LCALL	PREPMES1	;      "OK"
	MOV	A,#04h
	LCALL TRANSM	

	RET
;____________________________________________________________________________
;  10 "   END2"
CMD10:			
	CLR	DIRECTION	;  
C102:
	MOV	A,TIMESTEP	;  - - 
C101:	LCALL	ONEMS		;   1 
	DJNZ	ACC,C101		;
	LCALL	ONESTEP	;
	MOV	C,END2	
	JC	C102	
				;     
	MOV	02h,#'6'		;
	MOV	03h,#'0'		;
	LCALL	PREPCMD	;
	LCALL	PREPMES1	;     "OK"
	MOV	A,#04h		;
	LCALL TRANSM		;
	
	RET
;____________________________________________________________________________
;  11 " "
CMD11:	
				;  -  
				;    NCNVRT..		
	LCALL	VALINI		;
	LCALL	ASIITOB		;
	MOV	NCNVRT,ARLO	;	
				;  ..
	MOV	SIGLO,#00h	;
	MOV	SIGHI,#00h	;
				;NCNVRT    
				;   
CN2:				;  -  SIGLO  SIGHI..
	SETB	SCONV		; 
CN1:	MOV	A,ADCCON3	; ...
	JB	ACC.7,CN1	;... 

	MOV	A,SIGLO		;
	CLR	C		;
	ADD	A,ADCDATAL	;
	MOV	SIGLO,A		;
	ANL	ADCDATAH,#0Fh	;
	MOV	A,SIGHI		;
	ADDC	A,ADCDATAH	;
	MOV	SIGHI,A		;

	DJNZ	NCNVRT,CN2	; -   -   

	MOV	00h,SIGLO	;    ..
	MOV	01h,SIGHI	;..     BCD 
	LCALL	B2DEC		;
		;  
	MOV	02h,#'6'		;   ..
	MOV	03h,#'1'		;.. ..
	LCALL	PREPCMD	;..  
	MOV	R2,#05h		;5 - -   
	MOV	R0,#0Ch		; R0 -      
				; R1  (  PREPCMD )   
				; 
C111:	MOV	A,@R0		;
	ADD	A,#30h		;   ASII 
	MOV	@R1,A		;
	DEC	R0		;
	INC	R1		;
	DJNZ	R2,C111		;

	MOV	A,#07h		;
	LCALL TRANSM		;
	
	RET
;____________________________________________________________________________
;  12 "     msec"
CMD12:			
	LCALL	VALINI		;
	LCALL	ASIITOB		;   BIN 
	MOV	TIMESTEP,ARLO	;
				;     
	MOV	02h,#'6'		;
	MOV	03h,#'2'		;
	LCALL	PREPCMD	;
	LCALL	PREPMES1	;     "OK"
	MOV	A,#04h		;
	LCALL TRANSM		;

	RET
;____________________________________________________________________________
;  13 "  TIMER0"
CMD13:			
	LCALL	VALINI		;
	LCALL	ASIITOB		;   BIN 
	MOV	TH0,ARLO	;LowByte  TH , ..  Timer0 -   2
				;     
	MOV	02h,#'6'		;
	MOV	03h,#'3'		;
	LCALL	PREPCMD	;
	LCALL	PREPMES1	;     "OK"
	MOV	A,#04h
	LCALL TRANSM

	RET
;____________________________________________________________________________
;  14 " "
CMD14:
	MOV	A,P3		; 
	ANL	A,#00001100b	;  
;	CLR	A
;	ADD	A,P3

	RR	A		;  ..
	RR	A		;  ..
	MOV	02h,#'6'		;
	MOV	03h,#'4'		;
	LCALL	PREPCMD	;
	MOV	@R1,A		;     
	MOV	A,#03h		;
	LCALL TRANSM		;

	RET
;____________________________________________________________________________
;    
CMD15:
	CLR	RS0		;
	CLR	RS1		;
	MOV	R0,#BUFRXD	;
	MOV	02h,@R0		;
	INC	R0		;
	MOV	03h,@R0		;
	LCALL	PREPCMD	;
	LCALL	PREPMES2	;
	MOV	A,#04h
	LCALL TRANSM	

	RET	
;____________________________________________________________________________
;   ARNUM  ARBEG   ,  
; 
VALINI:
	MOV	A,BYTESR	; - .. 
	CLR	CY		;.. ..
	SUBB	A,#02h		;..  
	MOV	ARNUM,A	;  
	MOV	A,#BUFRXD	;   .. 
	ADD	A,BYTESR	;..  
	DEC	A		;..ASII 
	MOV	ARBEG,A	; 

	RET
;____________________________________________________________________________
;       ASII 
;    .     
;    
; :   ARBEG     . 
;   ARNUM - . 
; :  ARLO - .,  ARHI - . 

ASIITOB:
	;--------    0Ch - 0Fh    ---------
	;--------  ASII   - , --------- 
	;--------    0Ch - ,   0Fh -   ---------

	MOV	PSW,#00h	;
	MOV	R0,#0Fh		; R0    
	MOV	A,#04h		;  ..
	SUBB	A,ARNUM	;..    
ATB1:	JZ	ATB2		;
	MOV	@R0,#00h	;
	DEC	ACC		;
	DEC	R0		;
	SJMP	ATB1		;
	;--------    ASII    --------- 
	;-------- -    ---------
	;--------  0Ch - 0Fh  ---------
ATB2:	MOV	B,ARNUM	;
	MOV	R0,#0Ch		;
	MOV	R1,ARBEG	;
ATB3:	CLR	CY		;
	MOV	A,@R1		;
	SUBB	A,#30h		;
	MOV	@R0,A		;
	INC	R0		;
	DEC	R1		;
	DJNZ	B,ATB3		;
	;--------  2      BIN   ---------

	CLR	CY
	MOV	A,0Fh
	MOV	B,#0Ah
	MUL	AB
	XCH	A,B
	MOV	A,0Eh
	ADD	A,B
	MOV	B,#64h
	MUL	AB
	MOV	ARLO,A
	MOV	ARHI,B
	;--------      ---------
	MOV	A,0Dh
	CLR	CY
	MOV	B,#0Ah
	MUL	AB
	XCH	A,B
	MOV	A,0Ch
	ADD	A,B
	;-------- -    ---------
	CLR	CY
	ADD	A,ARLO
	MOV	ARLO,A
	MOV	A,#00h
	ADDC	A,ARHI
	MOV	ARHI,A

	RET
;____________________________________________________________________________
;         
; :  00h -      ;  01h -  
; :      08h - 0Ch ,   
;
B2DEC:
				;   
				;        04h - 07h 
	MOV	A,00h		;
	ANL	00h,#00001111b	;
	MOV	04h,00h		; .  .  
	ANL	A,#11110000b	;
	SWAP	A		;
	MOV	05h,A		; .  .  

	MOV	A,01h		;
	ANL	01h,#00001111b	;
	MOV	06h,01h		; .  .  
	ANL	A,#11110000b	;
	SWAP	A		;
	MOV	07h,A		; .  .  	

	CLR	RS0
	CLR	RS1
	MOV	R3,#04h		;
	MOV	R1,#08h		;

BD2:	
	CLR	A		;
	MOV	R2,#04h		;
	MOV	R0,#07h		;
BD1:	
	XCHD	A,@R0		;
	MOV	B,#0Ah		;
	DIV	AB		;
	MOV	@R1,B		;
	MOV	@R0,A		;
	XCH	A,B		;
	SWAP	A		;
	DEC	R0		;
	DJNZ	R2,BD1		;
	INC	R1		;
	DJNZ	R3,BD2		;
	MOV	0Ch,B		;

	RET
;____________________________________________________________________________
;       RS232;   - -   
TRANSM:
		;      
		;  (    TI ), 
		;      UART
	CLR	ES		;
		;   
	MOV	SBUF,#'!'
	JNB	TI,$
	CLR	TI
	CPL	LDTRD
	
	CLR	RS0
	CLR	RS1
	MOV	R0,#BUFTRD
		;    
TRNS1:	MOV	SBUF,@R0
	JNB	TI,$
	CLR	TI
	CPL	LDTRD
	INC	R0
	DEC	ACC
	JNZ	TRNS1
		;    -  0Dh
	MOV	SBUF,#0Dh
	JNB	TI,$
	CLR	TI
	CPL	LDTRD

	SETB	ES		;    UART

	RET
;____________________________________________________________________________
;  
ONEMS:
			;230  ,   4.34  
	MOV     B,#230	;
OM1:	NOP
	NOP
	DJNZ    B,OM1	;

	RET
;____________________________________________________________________________
;   
;    DIRECTION

ONESTEP:
	MOV	A,PHASESM
	JNB	DIRECTION,OS1
				;   "." 
	RL	A
	MOV	C,ACC.4
	MOV	ACC.0,C
	CLR	ACC.4
	SJMP	OS2
				;   "." 
OS1:	RRC	A
	MOV	ACC.3,C
	CLR	ACC.7
OS2:	MOV	PHASESM,A	; 
				;  
	ORL	A,SRSST
	MOV	P2,A

	RET
;____________________________________________________________________________
;       
PREPCMD:
	CLR	RS0
	CLR	RS1
	MOV	R0,#00h
	MOV	R1,#BUFTRD
		;      
	MOV	@R1,02h
	INC	R1
	MOV	@R1,03h
	INC	R1

	RET
;____________________________________________________________________________
;         
;  - "OK"
PREPMES1:
	MOV	B,#02h
	MOV	DPTR,#MESSAGE1
PM11:	MOV	A,R0
	MOVC	A,@A+DPTR
	MOV	@R1,A
	INC	R1
	INC	R0
	DJNZ	B,PM11

	RET
;____________________________________________________________________________
;          
PREPMES2:
	MOV	B,#02h
	MOV	DPTR,#MESSAGE2
PM21:	MOV	A,R0
	MOVC	A,@A+DPTR
	MOV	@R1,A
	INC	R1
	INC	R0
	DJNZ	B,PM21

	RET
;-----------------------------------------------------------  ----------------------------------------------------

	IDENTIF:		DB	'APPERT'	; 
	MESSAGE1:	DB	'OK'		;  .. 
						;.. 
	MESSAGE2:	DB	'NO'		;  .. 
						
END